/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io;

import com.aptana.core.epl.IMemento;
import com.aptana.ide.core.io.ConnectionPoint;
import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LocalConnectionPoint
extends ConnectionPoint {
    public static final String TYPE = "local";
    private static final String ELEMENT_PATH = "path";
    private IPath path;

    public LocalConnectionPoint() {
        super(TYPE);
    }

    public LocalConnectionPoint(IPath path) {
        super(TYPE);
        this.path = path;
    }

    public IPath getPath() {
        return this.path;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public File getFile() {
        return this.path.toFile();
    }

    public URI getRootURI() {
        return EFS.getLocalFileSystem().fromLocalFile(this.path.toFile()).toURI();
    }

    public IFileStore getRoot() throws CoreException {
        return EFS.getLocalFileSystem().fromLocalFile(this.path.toFile());
    }

    public Object getAdapter(Class adapter) {
        if (File.class.equals((Object)adapter)) {
            return this.getFile();
        }
        return super.getAdapter(adapter);
    }

    protected void loadState(IMemento memento) {
        super.loadState(memento);
        IMemento child = memento.getChild(ELEMENT_PATH);
        if (child != null) {
            this.path = Path.fromPortableString((String)child.getTextData());
        }
    }

    protected void saveState(IMemento memento) {
        super.saveState(memento);
        memento.createChild(ELEMENT_PATH).putTextData(this.path.toPortableString());
    }
}

